import{NodeType,NodeProp,NodeSet,Tree,Parser,parseMixed}from"@lezer/common";import{styleTags,tags,Tag}from"@lezer/highlight";class CompositeBlock{static create(e,t,n,s,r){return new CompositeBlock(e,t,n,s+(s<<8)+e+(t<<4)|0,r,[],[])}constructor(e,t,n,s,r,i,a){this.type=e,this.value=t,this.from=n,this.hash=s,this.end=r,this.children=i,this.positions=a,this.hashProp=[[NodeProp.contextHash,s]]}addChild(e,t){e.prop(NodeProp.contextHash)!=this.hash&&(e=new Tree(e.type,e.children,e.positions,e.length,this.hashProp)),this.children.push(e),this.positions.push(t)}toTree(e,t=this.end){let n=this.children.length-1;return n>=0&&(t=Math.max(t,this.positions[n]+this.children[n].length+this.from)),new Tree(e.types[this.type],this.children,this.positions,t-this.from).balance({makeTree:(e,t,n)=>new Tree(NodeType.none,e,t,n,this.hashProp)})}}var Type;!function(e){e[e.Document=1]="Document",e[e.CodeBlock=2]="CodeBlock",e[e.FencedCode=3]="FencedCode",e[e.Blockquote=4]="Blockquote",e[e.HorizontalRule=5]="HorizontalRule",e[e.BulletList=6]="BulletList",e[e.OrderedList=7]="OrderedList",e[e.ListItem=8]="ListItem",e[e.ATXHeading1=9]="ATXHeading1",e[e.ATXHeading2=10]="ATXHeading2",e[e.ATXHeading3=11]="ATXHeading3",e[e.ATXHeading4=12]="ATXHeading4",e[e.ATXHeading5=13]="ATXHeading5",e[e.ATXHeading6=14]="ATXHeading6",e[e.SetextHeading1=15]="SetextHeading1",e[e.SetextHeading2=16]="SetextHeading2",e[e.HTMLBlock=17]="HTMLBlock",e[e.LinkReference=18]="LinkReference",e[e.Paragraph=19]="Paragraph",e[e.CommentBlock=20]="CommentBlock",e[e.ProcessingInstructionBlock=21]="ProcessingInstructionBlock",e[e.Escape=22]="Escape",e[e.Entity=23]="Entity",e[e.HardBreak=24]="HardBreak",e[e.Emphasis=25]="Emphasis",e[e.StrongEmphasis=26]="StrongEmphasis",e[e.Link=27]="Link",e[e.Image=28]="Image",e[e.InlineCode=29]="InlineCode",e[e.HTMLTag=30]="HTMLTag",e[e.Comment=31]="Comment",e[e.ProcessingInstruction=32]="ProcessingInstruction",e[e.URL=33]="URL",e[e.HeaderMark=34]="HeaderMark",e[e.QuoteMark=35]="QuoteMark",e[e.ListMark=36]="ListMark",e[e.LinkMark=37]="LinkMark",e[e.EmphasisMark=38]="EmphasisMark",e[e.CodeMark=39]="CodeMark",e[e.CodeText=40]="CodeText",e[e.CodeInfo=41]="CodeInfo",e[e.LinkTitle=42]="LinkTitle",e[e.LinkLabel=43]="LinkLabel"}(Type||(Type={}));class LeafBlock{constructor(e,t){this.start=e,this.content=t,this.marks=[],this.parsers=[]}}class Line{constructor(){this.text="",this.baseIndent=0,this.basePos=0,this.depth=0,this.markers=[],this.pos=0,this.indent=0,this.next=-1}forward(){this.basePos>this.pos&&this.forwardInner()}forwardInner(){let e=this.skipSpace(this.basePos);this.indent=this.countIndent(e,this.pos,this.indent),this.pos=e,this.next=e==this.text.length?-1:this.text.charCodeAt(e)}skipSpace(e){return skipSpace(this.text,e)}reset(e){for(this.text=e,this.baseIndent=this.basePos=this.pos=this.indent=0,this.forwardInner(),this.depth=1;this.markers.length;)this.markers.pop()}moveBase(e){this.basePos=e,this.baseIndent=this.countIndent(e,this.pos,this.indent)}moveBaseColumn(e){this.baseIndent=e,this.basePos=this.findColumn(e)}addMarker(e){this.markers.push(e)}countIndent(e,t=0,n=0){for(let s=t;s<e;s++)n+=9==this.text.charCodeAt(s)?4-n%4:1;return n}findColumn(e){let t=0;for(let n=0;t<this.text.length&&n<e;t++)n+=9==this.text.charCodeAt(t)?4-n%4:1;return t}scrub(){if(!this.baseIndent)return this.text;let e="";for(let t=0;t<this.basePos;t++)e+=" ";return e+this.text.slice(this.basePos)}}function skipForList(e,t,n){if(n.pos==n.text.length||e!=t.block&&n.indent>=t.stack[n.depth+1].value+n.baseIndent)return!0;if(n.indent>=n.baseIndent+4)return!1;let s=(e.type==Type.OrderedList?isOrderedList:isBulletList)(n,t,!1);return s>0&&(e.type!=Type.BulletList||isHorizontalRule(n,t,!1)<0)&&n.text.charCodeAt(n.pos+s-1)==e.value}const DefaultSkipMarkup={[Type.Blockquote]:(e,t,n)=>62==n.next&&(n.markers.push(elt(Type.QuoteMark,t.lineStart+n.pos,t.lineStart+n.pos+1)),n.moveBase(n.pos+(space(n.text.charCodeAt(n.pos+1))?2:1)),e.end=t.lineStart+n.text.length,!0),[Type.ListItem]:(e,t,n)=>!(n.indent<n.baseIndent+e.value&&n.next>-1)&&(n.moveBaseColumn(n.baseIndent+e.value),!0),[Type.OrderedList]:skipForList,[Type.BulletList]:skipForList,[Type.Document]:()=>!0};function space(e){return 32==e||9==e||10==e||13==e}function skipSpace(e,t=0){for(;t<e.length&&space(e.charCodeAt(t));)t++;return t}function skipSpaceBack(e,t,n){for(;t>n&&space(e.charCodeAt(t-1));)t--;return t}function isFencedCode(e){if(96!=e.next&&126!=e.next)return-1;let t=e.pos+1;for(;t<e.text.length&&e.text.charCodeAt(t)==e.next;)t++;if(t<e.pos+3)return-1;if(96==e.next)for(let n=t;n<e.text.length;n++)if(96==e.text.charCodeAt(n))return-1;return t}function isBlockquote(e){return 62!=e.next?-1:32==e.text.charCodeAt(e.pos+1)?2:1}function isHorizontalRule(e,t,n){if(42!=e.next&&45!=e.next&&95!=e.next)return-1;let s=1;for(let t=e.pos+1;t<e.text.length;t++){let n=e.text.charCodeAt(t);if(n==e.next)s++;else if(!space(n))return-1}return n&&45==e.next&&isSetextUnderline(e)>-1&&e.depth==t.stack.length||s<3?-1:1}function inList(e,t){for(let n=e.stack.length-1;n>=0;n--)if(e.stack[n].type==t)return!0;return!1}function isBulletList(e,t,n){return 45!=e.next&&43!=e.next&&42!=e.next||e.pos!=e.text.length-1&&!space(e.text.charCodeAt(e.pos+1))||!(!n||inList(t,Type.BulletList)||e.skipSpace(e.pos+2)<e.text.length)?-1:1}function isOrderedList(e,t,n){let s=e.pos,r=e.next;for(;r>=48&&r<=57;){if(s++,s==e.text.length)return-1;r=e.text.charCodeAt(s)}return s==e.pos||s>e.pos+9||46!=r&&41!=r||s<e.text.length-1&&!space(e.text.charCodeAt(s+1))||n&&!inList(t,Type.OrderedList)&&(e.skipSpace(s+1)==e.text.length||s>e.pos+1||49!=e.next)?-1:s+1-e.pos}function isAtxHeading(e){if(35!=e.next)return-1;let t=e.pos+1;for(;t<e.text.length&&35==e.text.charCodeAt(t);)t++;if(t<e.text.length&&32!=e.text.charCodeAt(t))return-1;let n=t-e.pos;return n>6?-1:n}function isSetextUnderline(e){if(45!=e.next&&61!=e.next||e.indent>=e.baseIndent+4)return-1;let t=e.pos+1;for(;t<e.text.length&&e.text.charCodeAt(t)==e.next;)t++;let n=t;for(;t<e.text.length&&space(e.text.charCodeAt(t));)t++;return t==e.text.length?n:-1}const EmptyLine=/^[ \t]*$/,CommentEnd=/-->/,ProcessingEnd=/\?>/,HTMLBlockStyle=[[/^<(?:script|pre|style)(?:\s|>|$)/i,/<\/(?:script|pre|style)>/i],[/^\s*<!--/,CommentEnd],[/^\s*<\?/,ProcessingEnd],[/^\s*<![A-Z]/,/>/],[/^\s*<!\[CDATA\[/,/\]\]>/],[/^\s*<\/?(?:address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul)(?:\s|\/?>|$)/i,EmptyLine],[/^\s*(?:<\/[a-z][\w-]*\s*>|<[a-z][\w-]*(\s+[a-z:_][\w-.]*(?:\s*=\s*(?:[^\s"'=<>`]+|'[^']*'|"[^"]*"))?)*\s*>)\s*$/i,EmptyLine]];function isHTMLBlock(e,t,n){if(60!=e.next)return-1;let s=e.text.slice(e.pos);for(let e=0,t=HTMLBlockStyle.length-(n?1:0);e<t;e++)if(HTMLBlockStyle[e][0].test(s))return e;return-1}function getListIndent(e,t){let n=e.countIndent(t,e.pos,e.indent),s=e.countIndent(e.skipSpace(t),t,n);return s>=n+5?n+1:s}function addCodeText(e,t,n){let s=e.length-1;s>=0&&e[s].to==t&&e[s].type==Type.CodeText?e[s].to=n:e.push(elt(Type.CodeText,t,n))}const DefaultBlockParsers={LinkReference:void 0,IndentedCode(e,t){let n=t.baseIndent+4;if(t.indent<n)return!1;let s=t.findColumn(n),r=e.lineStart+s,i=e.lineStart+t.text.length,a=[],o=[];for(addCodeText(a,r,i);e.nextLine()&&t.depth>=e.stack.length;)if(t.pos==t.text.length){addCodeText(o,e.lineStart-1,e.lineStart);for(let e of t.markers)o.push(e)}else{if(t.indent<n)break;{if(o.length){for(let e of o)e.type==Type.CodeText?addCodeText(a,e.from,e.to):a.push(e);o=[]}addCodeText(a,e.lineStart-1,e.lineStart);for(let e of t.markers)a.push(e);i=e.lineStart+t.text.length;let n=e.lineStart+t.findColumn(t.baseIndent+4);n<i&&addCodeText(a,n,i)}}return o.length&&(o=o.filter((e=>e.type!=Type.CodeText)),o.length&&(t.markers=o.concat(t.markers))),e.addNode(e.buffer.writeElements(a,-r).finish(Type.CodeBlock,i-r),r),!0},FencedCode(e,t){let n=isFencedCode(t);if(n<0)return!1;let s=e.lineStart+t.pos,r=t.next,i=n-t.pos,a=t.skipSpace(n),o=skipSpaceBack(t.text,t.text.length,a),l=[elt(Type.CodeMark,s,s+i)];a<o&&l.push(elt(Type.CodeInfo,e.lineStart+a,e.lineStart+o));for(let n=!0;e.nextLine()&&t.depth>=e.stack.length;n=!1){let s=t.pos;if(t.indent-t.baseIndent<4)for(;s<t.text.length&&t.text.charCodeAt(s)==r;)s++;if(s-t.pos>=i&&t.skipSpace(s)==t.text.length){for(let e of t.markers)l.push(e);l.push(elt(Type.CodeMark,e.lineStart+t.pos,e.lineStart+s)),e.nextLine();break}{n||addCodeText(l,e.lineStart-1,e.lineStart);for(let e of t.markers)l.push(e);let s=e.lineStart+t.basePos,r=e.lineStart+t.text.length;s<r&&addCodeText(l,s,r)}}return e.addNode(e.buffer.writeElements(l,-s).finish(Type.FencedCode,e.prevLineEnd()-s),s),!0},Blockquote(e,t){let n=isBlockquote(t);return!(n<0)&&(e.startContext(Type.Blockquote,t.pos),e.addNode(Type.QuoteMark,e.lineStart+t.pos,e.lineStart+t.pos+1),t.moveBase(t.pos+n),null)},HorizontalRule(e,t){if(isHorizontalRule(t,e,!1)<0)return!1;let n=e.lineStart+t.pos;return e.nextLine(),e.addNode(Type.HorizontalRule,n),!0},BulletList(e,t){let n=isBulletList(t,e,!1);if(n<0)return!1;e.block.type!=Type.BulletList&&e.startContext(Type.BulletList,t.basePos,t.next);let s=getListIndent(t,t.pos+1);return e.startContext(Type.ListItem,t.basePos,s-t.baseIndent),e.addNode(Type.ListMark,e.lineStart+t.pos,e.lineStart+t.pos+n),t.moveBaseColumn(s),null},OrderedList(e,t){let n=isOrderedList(t,e,!1);if(n<0)return!1;e.block.type!=Type.OrderedList&&e.startContext(Type.OrderedList,t.basePos,t.text.charCodeAt(t.pos+n-1));let s=getListIndent(t,t.pos+n);return e.startContext(Type.ListItem,t.basePos,s-t.baseIndent),e.addNode(Type.ListMark,e.lineStart+t.pos,e.lineStart+t.pos+n),t.moveBaseColumn(s),null},ATXHeading(e,t){let n=isAtxHeading(t);if(n<0)return!1;let s=t.pos,r=e.lineStart+s,i=skipSpaceBack(t.text,t.text.length,s),a=i;for(;a>s&&t.text.charCodeAt(a-1)==t.next;)a--;a!=i&&a!=s&&space(t.text.charCodeAt(a-1))||(a=t.text.length);let o=e.buffer.write(Type.HeaderMark,0,n).writeElements(e.parser.parseInline(t.text.slice(s+n+1,a),r+n+1),-r);a<t.text.length&&o.write(Type.HeaderMark,a-s,i-s);let l=o.finish(Type.ATXHeading1-1+n,t.text.length-s);return e.nextLine(),e.addNode(l,r),!0},HTMLBlock(e,t){let n=isHTMLBlock(t,e,!1);if(n<0)return!1;let s=e.lineStart+t.pos,r=HTMLBlockStyle[n][1],i=[],a=r!=EmptyLine;for(;!r.test(t.text)&&e.nextLine();){if(t.depth<e.stack.length){a=!1;break}for(let e of t.markers)i.push(e)}a&&e.nextLine();let o=r==CommentEnd?Type.CommentBlock:r==ProcessingEnd?Type.ProcessingInstructionBlock:Type.HTMLBlock,l=e.prevLineEnd();return e.addNode(e.buffer.writeElements(i,-s).finish(o,l-s),s),!0},SetextHeading:void 0};class LinkReferenceParser{constructor(e){this.stage=0,this.elts=[],this.pos=0,this.start=e.start,this.advance(e.content)}nextLine(e,t,n){if(-1==this.stage)return!1;let s=n.content+"\n"+t.scrub(),r=this.advance(s);return r>-1&&r<s.length&&this.complete(e,n,r)}finish(e,t){return(2==this.stage||3==this.stage)&&skipSpace(t.content,this.pos)==t.content.length&&this.complete(e,t,t.content.length)}complete(e,t,n){return e.addLeafElement(t,elt(Type.LinkReference,this.start,this.start+n,this.elts)),!0}nextStage(e){return e?(this.pos=e.to-this.start,this.elts.push(e),this.stage++,!0):(!1===e&&(this.stage=-1),!1)}advance(e){for(;;){if(-1==this.stage)return-1;if(0==this.stage){if(!this.nextStage(parseLinkLabel(e,this.pos,this.start,!0)))return-1;if(58!=e.charCodeAt(this.pos))return this.stage=-1;this.elts.push(elt(Type.LinkMark,this.pos+this.start,this.pos+this.start+1)),this.pos++}else{if(1!=this.stage){if(2==this.stage){let t=skipSpace(e,this.pos),n=0;if(t>this.pos){let s=parseLinkTitle(e,t,this.start);if(s){let t=lineEnd(e,s.to-this.start);t>0&&(this.nextStage(s),n=t)}}return n||(n=lineEnd(e,this.pos)),n>0&&n<e.length?n:-1}return lineEnd(e,this.pos)}if(!this.nextStage(parseURL(e,skipSpace(e,this.pos),this.start)))return-1}}}}function lineEnd(e,t){for(;t<e.length;t++){let n=e.charCodeAt(t);if(10==n)break;if(!space(n))return-1}return t}class SetextHeadingParser{nextLine(e,t,n){let s=t.depth<e.stack.length?-1:isSetextUnderline(t),r=t.next;if(s<0)return!1;let i=elt(Type.HeaderMark,e.lineStart+t.pos,e.lineStart+s);return e.nextLine(),e.addLeafElement(n,elt(61==r?Type.SetextHeading1:Type.SetextHeading2,n.start,e.prevLineEnd(),[...e.parser.parseInline(n.content,n.start),i])),!0}finish(){return!1}}const DefaultLeafBlocks={LinkReference:(e,t)=>91==t.content.charCodeAt(0)?new LinkReferenceParser(t):null,SetextHeading:()=>new SetextHeadingParser},DefaultEndLeaf=[(e,t)=>isAtxHeading(t)>=0,(e,t)=>isFencedCode(t)>=0,(e,t)=>isBlockquote(t)>=0,(e,t)=>isBulletList(t,e,!0)>=0,(e,t)=>isOrderedList(t,e,!0)>=0,(e,t)=>isHorizontalRule(t,e,!0)>=0,(e,t)=>isHTMLBlock(t,e,!0)>=0],scanLineResult={text:"",end:0};class BlockContext{constructor(e,t,n,s){this.parser=e,this.input=t,this.ranges=s,this.line=new Line,this.atEnd=!1,this.reusePlaceholders=new Map,this.stoppedAt=null,this.rangeI=0,this.to=s[s.length-1].to,this.lineStart=this.absoluteLineStart=this.absoluteLineEnd=s[0].from,this.block=CompositeBlock.create(Type.Document,0,this.lineStart,0,0),this.stack=[this.block],this.fragments=n.length?new FragmentCursor(n,t):null,this.readLine()}get parsedPos(){return this.absoluteLineStart}advance(){if(null!=this.stoppedAt&&this.absoluteLineStart>this.stoppedAt)return this.finish();let{line:e}=this;for(;;){for(;e.depth<this.stack.length;)this.finishContext();for(let t of e.markers)this.addNode(t.type,t.from,t.to);if(e.pos<e.text.length)break;if(!this.nextLine())return this.finish()}if(this.fragments&&this.reuseFragment(e.basePos))return null;e:for(;;){for(let t of this.parser.blockParsers)if(t){let n=t(this,e);if(0!=n){if(1==n)return null;e.forward();continue e}}break}let t=new LeafBlock(this.lineStart+e.pos,e.text.slice(e.pos));for(let e of this.parser.leafBlockParsers)if(e){let n=e(this,t);n&&t.parsers.push(n)}e:for(;this.nextLine()&&e.pos!=e.text.length;){if(e.indent<e.baseIndent+4)for(let n of this.parser.endLeafBlock)if(n(this,e,t))break e;for(let n of t.parsers)if(n.nextLine(this,e,t))return null;t.content+="\n"+e.scrub();for(let n of e.markers)t.marks.push(n)}return this.finishLeaf(t),null}stopAt(e){if(null!=this.stoppedAt&&this.stoppedAt<e)throw new RangeError("Can't move stoppedAt forward");this.stoppedAt=e}reuseFragment(e){if(!this.fragments.moveTo(this.absoluteLineStart+e,this.absoluteLineStart)||!this.fragments.matches(this.block.hash))return!1;let t=this.fragments.takeNodes(this);return!!t&&(this.absoluteLineStart+=t,this.lineStart=toRelative(this.absoluteLineStart,this.ranges),this.moveRangeI(),this.absoluteLineStart<this.to?(this.lineStart++,this.absoluteLineStart++,this.readLine()):(this.atEnd=!0,this.readLine()),!0)}get depth(){return this.stack.length}parentType(e=this.depth-1){return this.parser.nodeSet.types[this.stack[e].type]}nextLine(){return this.lineStart+=this.line.text.length,this.absoluteLineEnd>=this.to?(this.absoluteLineStart=this.absoluteLineEnd,this.atEnd=!0,this.readLine(),!1):(this.lineStart++,this.absoluteLineStart=this.absoluteLineEnd+1,this.moveRangeI(),this.readLine(),!0)}moveRangeI(){for(;this.rangeI<this.ranges.length-1&&this.absoluteLineStart>=this.ranges[this.rangeI].to;)this.rangeI++,this.absoluteLineStart=Math.max(this.absoluteLineStart,this.ranges[this.rangeI].from)}scanLine(e){let t=scanLineResult;if(t.end=e,e>=this.to)t.text="";else if(t.text=this.lineChunkAt(e),t.end+=t.text.length,this.ranges.length>1){let e=this.absoluteLineStart,n=this.rangeI;for(;this.ranges[n].to<t.end;){n++;let s=this.ranges[n].from,r=this.lineChunkAt(s);t.end=s+r.length,t.text=t.text.slice(0,this.ranges[n-1].to-e)+r,e=t.end-t.text.length}}return t}readLine(){let{line:e}=this,{text:t,end:n}=this.scanLine(this.absoluteLineStart);for(this.absoluteLineEnd=n,e.reset(t);e.depth<this.stack.length;e.depth++){let t=this.stack[e.depth],n=this.parser.skipContextMarkup[t.type];if(!n)throw new Error("Unhandled block context "+Type[t.type]);if(!n(t,this,e))break;e.forward()}}lineChunkAt(e){let t,n=this.input.chunk(e);if(this.input.lineChunks)t="\n"==n?"":n;else{let e=n.indexOf("\n");t=e<0?n:n.slice(0,e)}return e+t.length>this.to?t.slice(0,this.to-e):t}prevLineEnd(){return this.atEnd?this.lineStart:this.lineStart-1}startContext(e,t,n=0){this.block=CompositeBlock.create(e,n,this.lineStart+t,this.block.hash,this.lineStart+this.line.text.length),this.stack.push(this.block)}startComposite(e,t,n=0){this.startContext(this.parser.getNodeType(e),t,n)}addNode(e,t,n){"number"==typeof e&&(e=new Tree(this.parser.nodeSet.types[e],none,none,(null!=n?n:this.prevLineEnd())-t)),this.block.addChild(e,t-this.block.from)}addElement(e){this.block.addChild(e.toTree(this.parser.nodeSet),e.from-this.block.from)}addLeafElement(e,t){this.addNode(this.buffer.writeElements(injectMarks(t.children,e.marks),-t.from).finish(t.type,t.to-t.from),t.from)}finishContext(){let e=this.stack.pop(),t=this.stack[this.stack.length-1];t.addChild(e.toTree(this.parser.nodeSet),e.from-t.from),this.block=t}finish(){for(;this.stack.length>1;)this.finishContext();return this.addGaps(this.block.toTree(this.parser.nodeSet,this.lineStart))}addGaps(e){return this.ranges.length>1?injectGaps(this.ranges,0,e.topNode,this.ranges[0].from,this.reusePlaceholders):e}finishLeaf(e){for(let t of e.parsers)if(t.finish(this,e))return;let t=injectMarks(this.parser.parseInline(e.content,e.start),e.marks);this.addNode(this.buffer.writeElements(t,-e.start).finish(Type.Paragraph,e.content.length),e.start)}elt(e,t,n,s){return"string"==typeof e?elt(this.parser.getNodeType(e),t,n,s):new TreeElement(e,t)}get buffer(){return new Buffer(this.parser.nodeSet)}}function injectGaps(e,t,n,s,r){let i=e[t].to,a=[],o=[],l=n.from+s;function h(n,r){for(;r?n>=i:n>i;){let r=e[t+1].from-i;s+=r,n+=r,t++,i=e[t].to}}for(let p=n.firstChild;p;p=p.nextSibling){h(p.from+s,!0);let n,d=p.from+s,c=r.get(p.tree);c?n=c:p.to+s>i?(n=injectGaps(e,t,p,s,r),h(p.to+s,!1)):n=p.toTree(),a.push(n),o.push(d-l)}return h(n.to+s,!1),new Tree(n.type,a,o,n.to+s-l,n.tree?n.tree.propValues:void 0)}class MarkdownParser extends Parser{constructor(e,t,n,s,r,i,a,o,l){super(),this.nodeSet=e,this.blockParsers=t,this.leafBlockParsers=n,this.blockNames=s,this.endLeafBlock=r,this.skipContextMarkup=i,this.inlineParsers=a,this.inlineNames=o,this.wrappers=l,this.nodeTypes=Object.create(null);for(let t of e.types)this.nodeTypes[t.name]=t.id}createParse(e,t,n){let s=new BlockContext(this,e,t,n);for(let r of this.wrappers)s=r(s,e,t,n);return s}configure(e){let t=resolveConfig(e);if(!t)return this;let{nodeSet:n,skipContextMarkup:s}=this,r=this.blockParsers.slice(),i=this.leafBlockParsers.slice(),a=this.blockNames.slice(),o=this.inlineParsers.slice(),l=this.inlineNames.slice(),h=this.endLeafBlock.slice(),p=this.wrappers;if(nonEmpty(t.defineNodes)){s=Object.assign({},s);let e,r=n.types.slice();for(let n of t.defineNodes){let{name:t,block:i,composite:a,style:o}="string"==typeof n?{name:n}:n;if(r.some((e=>e.name==t)))continue;a&&(s[r.length]=(e,t,n)=>a(t,n,e.value));let l=r.length,h=a?["Block","BlockContext"]:i?l>=Type.ATXHeading1&&l<=Type.SetextHeading2?["Block","LeafBlock","Heading"]:["Block","LeafBlock"]:void 0;r.push(NodeType.define({id:l,name:t,props:h&&[[NodeProp.group,h]]})),o&&(e||(e={}),Array.isArray(o)||o instanceof Tag?e[t]=o:Object.assign(e,o))}n=new NodeSet(r),e&&(n=n.extend(styleTags(e)))}if(nonEmpty(t.props)&&(n=n.extend(...t.props)),nonEmpty(t.remove))for(let e of t.remove){let t=this.blockNames.indexOf(e),n=this.inlineNames.indexOf(e);t>-1&&(r[t]=i[t]=void 0),n>-1&&(o[n]=void 0)}if(nonEmpty(t.parseBlock))for(let e of t.parseBlock){let t=a.indexOf(e.name);if(t>-1)r[t]=e.parse,i[t]=e.leaf;else{let t=e.before?findName(a,e.before):e.after?findName(a,e.after)+1:a.length-1;r.splice(t,0,e.parse),i.splice(t,0,e.leaf),a.splice(t,0,e.name)}e.endLeaf&&h.push(e.endLeaf)}if(nonEmpty(t.parseInline))for(let e of t.parseInline){let t=l.indexOf(e.name);if(t>-1)o[t]=e.parse;else{let t=e.before?findName(l,e.before):e.after?findName(l,e.after)+1:l.length-1;o.splice(t,0,e.parse),l.splice(t,0,e.name)}}return t.wrap&&(p=p.concat(t.wrap)),new MarkdownParser(n,r,i,a,h,s,o,l,p)}getNodeType(e){let t=this.nodeTypes[e];if(null==t)throw new RangeError(`Unknown node type '${e}'`);return t}parseInline(e,t){let n=new InlineContext(this,e,t);e:for(let e=t;e<n.end;){let t=n.char(e);for(let s of this.inlineParsers)if(s){let r=s(n,t,e);if(r>=0){e=r;continue e}}e++}return n.resolveMarkers(0)}}function nonEmpty(e){return null!=e&&e.length>0}function resolveConfig(e){if(!Array.isArray(e))return e;if(0==e.length)return null;let t=resolveConfig(e[0]);if(1==e.length)return t;let n=resolveConfig(e.slice(1));if(!n||!t)return t||n;let s=(e,t)=>(e||none).concat(t||none),r=t.wrap,i=n.wrap;return{props:s(t.props,n.props),defineNodes:s(t.defineNodes,n.defineNodes),parseBlock:s(t.parseBlock,n.parseBlock),parseInline:s(t.parseInline,n.parseInline),remove:s(t.remove,n.remove),wrap:r?i?(e,t,n,s)=>r(i(e,t,n,s),t,n,s):r:i}}function findName(e,t){let n=e.indexOf(t);if(n<0)throw new RangeError(`Position specified relative to unknown parser ${t}`);return n}let nodeTypes=[NodeType.none];for(let e,t=1;e=Type[t];t++)nodeTypes[t]=NodeType.define({id:t,name:e,props:t>=Type.Escape?[]:[[NodeProp.group,t in DefaultSkipMarkup?["Block","BlockContext"]:["Block","LeafBlock"]]],top:"Document"==e});const none=[];class Buffer{constructor(e){this.nodeSet=e,this.content=[],this.nodes=[]}write(e,t,n,s=0){return this.content.push(e,t,n,4+4*s),this}writeElements(e,t=0){for(let n of e)n.writeTo(this,t);return this}finish(e,t){return Tree.build({buffer:this.content,nodeSet:this.nodeSet,reused:this.nodes,topID:e,length:t})}}class Element{constructor(e,t,n,s=none){this.type=e,this.from=t,this.to=n,this.children=s}writeTo(e,t){let n=e.content.length;e.writeElements(this.children,t),e.content.push(this.type,this.from+t,this.to+t,e.content.length+4-n)}toTree(e){return new Buffer(e).writeElements(this.children,-this.from).finish(this.type,this.to-this.from)}}class TreeElement{constructor(e,t){this.tree=e,this.from=t}get to(){return this.from+this.tree.length}get type(){return this.tree.type.id}get children(){return none}writeTo(e,t){e.nodes.push(this.tree),e.content.push(e.nodes.length-1,this.from+t,this.to+t,-1)}toTree(){return this.tree}}function elt(e,t,n,s){return new Element(e,t,n,s)}const EmphasisUnderscore={resolve:"Emphasis",mark:"EmphasisMark"},EmphasisAsterisk={resolve:"Emphasis",mark:"EmphasisMark"},LinkStart={},ImageStart={};class InlineDelimiter{constructor(e,t,n,s){this.type=e,this.from=t,this.to=n,this.side=s}}const Escapable="!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";let Punctuation=/[!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~\xA1\u2010-\u2027]/;try{Punctuation=new RegExp("[\\p{Pc}|\\p{Pd}|\\p{Pe}|\\p{Pf}|\\p{Pi}|\\p{Po}|\\p{Ps}]","u")}catch(e){}const DefaultInline={Escape(e,t,n){if(92!=t||n==e.end-1)return-1;let s=e.char(n+1);for(let t=0;t<32;t++)if(Escapable.charCodeAt(t)==s)return e.append(elt(Type.Escape,n,n+2));return-1},Entity(e,t,n){if(38!=t)return-1;let s=/^(?:#\d+|#x[a-f\d]+|\w+);/i.exec(e.slice(n+1,n+31));return s?e.append(elt(Type.Entity,n,n+1+s[0].length)):-1},InlineCode(e,t,n){if(96!=t||n&&96==e.char(n-1))return-1;let s=n+1;for(;s<e.end&&96==e.char(s);)s++;let r=s-n,i=0;for(;s<e.end;s++)if(96==e.char(s)){if(i++,i==r&&96!=e.char(s+1))return e.append(elt(Type.InlineCode,n,s+1,[elt(Type.CodeMark,n,n+r),elt(Type.CodeMark,s+1-r,s+1)]))}else i=0;return-1},HTMLTag(e,t,n){if(60!=t||n==e.end-1)return-1;let s=e.slice(n+1,e.end),r=/^(?:[a-z][-\w+.]+:[^\s>]+|[a-z\d.!#$%&'*+/=?^_`{|}~-]+@[a-z\d](?:[a-z\d-]{0,61}[a-z\d])?(?:\.[a-z\d](?:[a-z\d-]{0,61}[a-z\d])?)*)>/i.exec(s);if(r)return e.append(elt(Type.URL,n,n+1+r[0].length));let i=/^!--[^>](?:-[^-]|[^-])*?-->/i.exec(s);if(i)return e.append(elt(Type.Comment,n,n+1+i[0].length));let a=/^\?[^]*?\?>/.exec(s);if(a)return e.append(elt(Type.ProcessingInstruction,n,n+1+a[0].length));let o=/^(?:![A-Z][^]*?>|!\[CDATA\[[^]*?\]\]>|\/\s*[a-zA-Z][\w-]*\s*>|\s*[a-zA-Z][\w-]*(\s+[a-zA-Z:_][\w-.:]*(?:\s*=\s*(?:[^\s"'=<>`]+|'[^']*'|"[^"]*"))?)*\s*(\/\s*)?>)/.exec(s);return o?e.append(elt(Type.HTMLTag,n,n+1+o[0].length)):-1},Emphasis(e,t,n){if(95!=t&&42!=t)return-1;let s=n+1;for(;e.char(s)==t;)s++;let r=e.slice(n-1,n),i=e.slice(s,s+1),a=Punctuation.test(r),o=Punctuation.test(i),l=/\s|^$/.test(r),h=/\s|^$/.test(i),p=!h&&(!o||l||a),d=!l&&(!a||h||o),c=p&&(42==t||!d||a),f=d&&(42==t||!p||o);return e.append(new InlineDelimiter(95==t?EmphasisUnderscore:EmphasisAsterisk,n,s,(c?1:0)|(f?2:0)))},HardBreak(e,t,n){if(92==t&&10==e.char(n+1))return e.append(elt(Type.HardBreak,n,n+2));if(32==t){let t=n+1;for(;32==e.char(t);)t++;if(10==e.char(t)&&t>=n+2)return e.append(elt(Type.HardBreak,n,t+1))}return-1},Link:(e,t,n)=>91==t?e.append(new InlineDelimiter(LinkStart,n,n+1,1)):-1,Image:(e,t,n)=>33==t&&91==e.char(n+1)?e.append(new InlineDelimiter(ImageStart,n,n+2,1)):-1,LinkEnd(e,t,n){if(93!=t)return-1;for(let t=e.parts.length-1;t>=0;t--){let s=e.parts[t];if(s instanceof InlineDelimiter&&(s.type==LinkStart||s.type==ImageStart)){if(!s.side||e.skipSpace(s.to)==n&&!/[(\[]/.test(e.slice(n+1,n+2)))return e.parts[t]=null,-1;let r=e.takeContent(t),i=e.parts[t]=finishLink(e,r,s.type==LinkStart?Type.Link:Type.Image,s.from,n+1);if(s.type==LinkStart)for(let n=0;n<t;n++){let t=e.parts[n];t instanceof InlineDelimiter&&t.type==LinkStart&&(t.side=0)}return i.to}}return-1}};function finishLink(e,t,n,s,r){let{text:i}=e,a=e.char(r),o=r;if(t.unshift(elt(Type.LinkMark,s,s+(n==Type.Image?2:1))),t.push(elt(Type.LinkMark,r-1,r)),40==a){let n,s=e.skipSpace(r+1),a=parseURL(i,s-e.offset,e.offset);a&&(s=e.skipSpace(a.to),n=parseLinkTitle(i,s-e.offset,e.offset),n&&(s=e.skipSpace(n.to))),41==e.char(s)&&(t.push(elt(Type.LinkMark,r,r+1)),o=s+1,a&&t.push(a),n&&t.push(n),t.push(elt(Type.LinkMark,s,o)))}else if(91==a){let n=parseLinkLabel(i,r-e.offset,e.offset,!1);n&&(t.push(n),o=n.to)}return elt(n,s,o,t)}function parseURL(e,t,n){if(60==e.charCodeAt(t)){for(let s=t+1;s<e.length;s++){let r=e.charCodeAt(s);if(62==r)return elt(Type.URL,t+n,s+1+n);if(60==r||10==r)return!1}return null}{let s=0,r=t;for(let t=!1;r<e.length;r++){let n=e.charCodeAt(r);if(space(n))break;if(t)t=!1;else if(40==n)s++;else if(41==n){if(!s)break;s--}else 92==n&&(t=!0)}return r>t?elt(Type.URL,t+n,r+n):r==e.length&&null}}function parseLinkTitle(e,t,n){let s=e.charCodeAt(t);if(39!=s&&34!=s&&40!=s)return!1;let r=40==s?41:s;for(let s=t+1,i=!1;s<e.length;s++){let a=e.charCodeAt(s);if(i)i=!1;else{if(a==r)return elt(Type.LinkTitle,t+n,s+1+n);92==a&&(i=!0)}}return null}function parseLinkLabel(e,t,n,s){for(let r=!1,i=t+1,a=Math.min(e.length,i+999);i<a;i++){let a=e.charCodeAt(i);if(r)r=!1;else{if(93==a)return!s&&elt(Type.LinkLabel,t+n,i+1+n);if(s&&!space(a)&&(s=!1),91==a)return!1;92==a&&(r=!0)}}return null}class InlineContext{constructor(e,t,n){this.parser=e,this.text=t,this.offset=n,this.parts=[]}char(e){return e>=this.end?-1:this.text.charCodeAt(e-this.offset)}get end(){return this.offset+this.text.length}slice(e,t){return this.text.slice(e-this.offset,t-this.offset)}append(e){return this.parts.push(e),e.to}addDelimiter(e,t,n,s,r){return this.append(new InlineDelimiter(e,t,n,(s?1:0)|(r?2:0)))}addElement(e){return this.append(e)}resolveMarkers(e){for(let t=e;t<this.parts.length;t++){let n=this.parts[t];if(!(n instanceof InlineDelimiter&&n.type.resolve&&2&n.side))continue;let s,r=n.type==EmphasisUnderscore||n.type==EmphasisAsterisk,i=n.to-n.from,a=t-1;for(;a>=e;a--){let e=this.parts[a];if(e instanceof InlineDelimiter&&1&e.side&&e.type==n.type&&!(r&&(1&n.side||2&e.side)&&(e.to-e.from+i)%3==0&&((e.to-e.from)%3||i%3))){s=e;break}}if(!s)continue;let o=n.type.resolve,l=[],h=s.from,p=n.to;if(r){let e=Math.min(2,s.to-s.from,i);h=s.to-e,p=n.from+e,o=1==e?"Emphasis":"StrongEmphasis"}s.type.mark&&l.push(this.elt(s.type.mark,h,s.to));for(let e=a+1;e<t;e++)this.parts[e]instanceof Element&&l.push(this.parts[e]),this.parts[e]=null;n.type.mark&&l.push(this.elt(n.type.mark,n.from,p));let d=this.elt(o,h,p,l);this.parts[a]=r&&s.from!=h?new InlineDelimiter(s.type,s.from,h,s.side):null,(this.parts[t]=r&&n.to!=p?new InlineDelimiter(n.type,p,n.to,n.side):null)?this.parts.splice(t,0,d):this.parts[t]=d}let t=[];for(let n=e;n<this.parts.length;n++){let e=this.parts[n];e instanceof Element&&t.push(e)}return t}findOpeningDelimiter(e){for(let t=this.parts.length-1;t>=0;t--){let n=this.parts[t];if(n instanceof InlineDelimiter&&n.type==e)return t}return null}takeContent(e){let t=this.resolveMarkers(e);return this.parts.length=e,t}skipSpace(e){return skipSpace(this.text,e-this.offset)+this.offset}elt(e,t,n,s){return"string"==typeof e?elt(this.parser.getNodeType(e),t,n,s):new TreeElement(e,t)}}function injectMarks(e,t){if(!t.length)return e;if(!e.length)return t;let n=e.slice(),s=0;for(let e of t){for(;s<n.length&&n[s].to<e.to;)s++;if(s<n.length&&n[s].from<e.from){let t=n[s];t instanceof Element&&(n[s]=new Element(t.type,t.from,t.to,injectMarks(t.children,[e])))}else n.splice(s++,0,e)}return n}const NotLast=[Type.CodeBlock,Type.ListItem,Type.OrderedList,Type.BulletList];class FragmentCursor{constructor(e,t){this.fragments=e,this.input=t,this.i=0,this.fragment=null,this.fragmentEnd=-1,this.cursor=null,e.length&&(this.fragment=e[this.i++])}nextFragment(){this.fragment=this.i<this.fragments.length?this.fragments[this.i++]:null,this.cursor=null,this.fragmentEnd=-1}moveTo(e,t){for(;this.fragment&&this.fragment.to<=e;)this.nextFragment();if(!this.fragment||this.fragment.from>(e?e-1:0))return!1;if(this.fragmentEnd<0){let e=this.fragment.to;for(;e>0&&"\n"!=this.input.read(e-1,e);)e--;this.fragmentEnd=e?e-1:0}let n=this.cursor;n||(n=this.cursor=this.fragment.tree.cursor(),n.firstChild());let s=e+this.fragment.offset;for(;n.to<=s;)if(!n.parent())return!1;for(;;){if(n.from>=s)return this.fragment.from<=t;if(!n.childAfter(s))return!1}}matches(e){let t=this.cursor.tree;return t&&t.prop(NodeProp.contextHash)==e}takeNodes(e){let t=this.cursor,n=this.fragment.offset,s=this.fragmentEnd-(this.fragment.openEnd?1:0),r=e.absoluteLineStart,i=r,a=e.block.children.length,o=i,l=a;for(;;){if(t.to-n>s){if(t.type.isAnonymous&&t.firstChild())continue;break}let r=toRelative(t.from-n,e.ranges);if(t.to-n<=e.ranges[e.rangeI].to)e.addNode(t.tree,r);else{let n=new Tree(e.parser.nodeSet.types[Type.Paragraph],[],[],0,e.block.hashProp);e.reusePlaceholders.set(n,t.tree),e.addNode(n,r)}if(t.type.is("Block")&&(NotLast.indexOf(t.type.id)<0?(i=t.to-n,a=e.block.children.length):(i=o,a=l,o=t.to-n,l=e.block.children.length)),!t.nextSibling())break}for(;e.block.children.length>a;)e.block.children.pop(),e.block.positions.pop();return i-r}}function toRelative(e,t){let n=e;for(let s=1;s<t.length;s++){let r=t[s-1].to,i=t[s].from;r<e&&(n-=i-r)}return n}const markdownHighlighting=styleTags({"Blockquote/...":tags.quote,HorizontalRule:tags.contentSeparator,"ATXHeading1/... SetextHeading1/...":tags.heading1,"ATXHeading2/... SetextHeading2/...":tags.heading2,"ATXHeading3/...":tags.heading3,"ATXHeading4/...":tags.heading4,"ATXHeading5/...":tags.heading5,"ATXHeading6/...":tags.heading6,"Comment CommentBlock":tags.comment,Escape:tags.escape,Entity:tags.character,"Emphasis/...":tags.emphasis,"StrongEmphasis/...":tags.strong,"Link/... Image/...":tags.link,"OrderedList/... BulletList/...":tags.list,"BlockQuote/...":tags.quote,"InlineCode CodeText":tags.monospace,URL:tags.url,"HeaderMark HardBreak QuoteMark ListMark LinkMark EmphasisMark CodeMark":tags.processingInstruction,"CodeInfo LinkLabel":tags.labelName,LinkTitle:tags.string,Paragraph:tags.content}),parser=new MarkdownParser(new NodeSet(nodeTypes).extend(markdownHighlighting),Object.keys(DefaultBlockParsers).map((e=>DefaultBlockParsers[e])),Object.keys(DefaultBlockParsers).map((e=>DefaultLeafBlocks[e])),Object.keys(DefaultBlockParsers),DefaultEndLeaf,DefaultSkipMarkup,Object.keys(DefaultInline).map((e=>DefaultInline[e])),Object.keys(DefaultInline),[]);function leftOverSpace(e,t,n){let s=[];for(let r=e.firstChild,i=t;;r=r.nextSibling){let e=r?r.from:n;if(e>i&&s.push({from:i,to:e}),!r)break;i=r.to}return s}function parseCode(e){let{codeParser:t,htmlParser:n}=e,s=parseMixed(((e,s)=>{let r=e.type.id;if(!t||r!=Type.CodeBlock&&r!=Type.FencedCode){if(n&&(r==Type.HTMLBlock||r==Type.HTMLTag))return{parser:n,overlay:leftOverSpace(e.node,e.from,e.to)}}else{let n="";if(r==Type.FencedCode){let t=e.node.getChild(Type.CodeInfo);t&&(n=s.read(t.from,t.to))}let i=t(n);if(i)return{parser:i,overlay:e=>e.type.id==Type.CodeText}}return null}));return{wrap:s}}const StrikethroughDelim={resolve:"Strikethrough",mark:"StrikethroughMark"},Strikethrough={defineNodes:[{name:"Strikethrough",style:{"Strikethrough/...":tags.strikethrough}},{name:"StrikethroughMark",style:tags.processingInstruction}],parseInline:[{name:"Strikethrough",parse(e,t,n){if(126!=t||126!=e.char(n+1)||126==e.char(n+2))return-1;let s=e.slice(n-1,n),r=e.slice(n+2,n+3),i=/\s|^$/.test(s),a=/\s|^$/.test(r),o=Punctuation.test(s),l=Punctuation.test(r);return e.addDelimiter(StrikethroughDelim,n,n+2,!a&&(!l||i||o),!i&&(!o||a||l))},after:"Emphasis"}]};function parseRow(e,t,n=0,s,r=0){let i=0,a=!0,o=-1,l=-1,h=!1,p=()=>{s.push(e.elt("TableCell",r+o,r+l,e.parser.parseInline(t.slice(o,l),r+o)))};for(let d=n;d<t.length;d++){let n=t.charCodeAt(d);124!=n||h?(h||32!=n&&9!=n)&&(o<0&&(o=d),l=d+1):((!a||o>-1)&&i++,a=!1,s&&(o>-1&&p(),s.push(e.elt("TableDelimiter",d+r,d+r+1))),o=l=-1),h=!h&&92==n}return o>-1&&(i++,s&&p()),i}function hasPipe(e,t){for(let n=t;n<e.length;n++){let t=e.charCodeAt(n);if(124==t)return!0;92==t&&n++}return!1}const delimiterLine=/^\|?(\s*:?-+:?\s*\|)+(\s*:?-+:?\s*)?$/;class TableParser{constructor(){this.rows=null}nextLine(e,t,n){if(null==this.rows){let s;if(this.rows=!1,(45==t.next||58==t.next||124==t.next)&&delimiterLine.test(s=t.text.slice(t.pos))){let r=[];parseRow(e,n.content,0,r,n.start)==parseRow(e,s,t.pos)&&(this.rows=[e.elt("TableHeader",n.start,n.start+n.content.length,r),e.elt("TableDelimiter",e.lineStart+t.pos,e.lineStart+t.text.length)])}}else if(this.rows){let n=[];parseRow(e,t.text,t.pos,n,e.lineStart),this.rows.push(e.elt("TableRow",e.lineStart+t.pos,e.lineStart+t.text.length,n))}return!1}finish(e,t){return!!this.rows&&(e.addLeafElement(t,e.elt("Table",t.start,t.start+t.content.length,this.rows)),!0)}}const Table={defineNodes:[{name:"Table",block:!0},{name:"TableHeader",style:{"TableHeader/...":tags.heading}},"TableRow",{name:"TableCell",style:tags.content},{name:"TableDelimiter",style:tags.processingInstruction}],parseBlock:[{name:"Table",leaf:(e,t)=>hasPipe(t.content,0)?new TableParser:null,endLeaf(e,t,n){if(n.parsers.some((e=>e instanceof TableParser))||!hasPipe(t.text,t.basePos))return!1;let s=e.scanLine(e.absoluteLineEnd+1).text;return delimiterLine.test(s)&&parseRow(e,t.text,t.basePos)==parseRow(e,s,t.basePos)},before:"SetextHeading"}]};class TaskParser{nextLine(){return!1}finish(e,t){return e.addLeafElement(t,e.elt("Task",t.start,t.start+t.content.length,[e.elt("TaskMarker",t.start,t.start+3),...e.parser.parseInline(t.content.slice(3),t.start+3)])),!0}}const TaskList={defineNodes:[{name:"Task",block:!0,style:tags.list},{name:"TaskMarker",style:tags.atom}],parseBlock:[{name:"TaskList",leaf:(e,t)=>/^\[[ xX]\][ \t]/.test(t.content)&&"ListItem"==e.parentType().name?new TaskParser:null,after:"SetextHeading"}]},autolinkRE=/(www\.)|(https?:\/\/)|([\w.+-]+@)|(mailto:|xmpp:)/gy,urlRE=/[\w-]+(\.\w+(\.\w+)?)(\/[^\s<]*)?/gy,emailRE=/[\w.+-]+@[\w-]+\.[\w.-]+/gy,xmppResourceRE=/\/[a-zA-Z\d@.]+/gy;function count(e,t,n,s){let r=0;for(let i=t;i<n;i++)e[i]==s&&r++;return r}function autolinkURLEnd(e,t){urlRE.lastIndex=t;let n=urlRE.exec(e);if(!n)return-1;let s=t+n[0].length;for(;;){let n,r=e[s-1];if(/[?!.,:*_~]/.test(r)||")"==r&&count(e,t,s,")")>count(e,t,s,"("))s--;else{if(";"!=r||!(n=/&(?:#\d+|#x[a-f\d]+|\w+);$/.exec(e.slice(t,s))))break;s=t+n.index}}return s}function autolinkEmailEnd(e,t){emailRE.lastIndex=t;let n=emailRE.exec(e);if(!n)return-1;let s=n[0][n[0].length-1];return"_"==s||"-"==s?-1:t+n[0].length-("."==s?1:0)}const Autolink={parseInline:[{name:"Autolink",parse(e,t,n){let s=n-e.offset;autolinkRE.lastIndex=s;let r=autolinkRE.exec(e.text),i=-1;return r?(r[1]||r[2]?i=autolinkURLEnd(e.text,s+r[0].length):r[3]?i=autolinkEmailEnd(e.text,s):(i=autolinkEmailEnd(e.text,s+r[0].length),i>-1&&"xmpp:"==r[0]&&(xmppResourceRE.lastIndex=i,r=xmppResourceRE.exec(e.text),r&&(i=r.index+r[0].length))),i<0?-1:(e.addElement(e.elt("URL",n,i+e.offset)),i+e.offset)):-1}}]},GFM=[Table,TaskList,Strikethrough,Autolink];function parseSubSuper(e,t,n){return(s,r,i)=>{if(r!=e||s.char(i+1)==e)return-1;let a=[s.elt(n,i,i+1)];for(let r=i+1;r<s.end;r++){let o=s.char(r);if(o==e)return s.addElement(s.elt(t,i,r+1,a.concat(s.elt(n,r,r+1))));if(92==o&&a.push(s.elt("Escape",r,2+r++)),space(o))break}return-1}}const Superscript={defineNodes:[{name:"Superscript",style:tags.special(tags.content)},{name:"SuperscriptMark",style:tags.processingInstruction}],parseInline:[{name:"Superscript",parse:parseSubSuper(94,"Superscript","SuperscriptMark")}]},Subscript={defineNodes:[{name:"Subscript",style:tags.special(tags.content)},{name:"SubscriptMark",style:tags.processingInstruction}],parseInline:[{name:"Subscript",parse:parseSubSuper(126,"Subscript","SubscriptMark")}]},Emoji={defineNodes:[{name:"Emoji",style:tags.character}],parseInline:[{name:"Emoji",parse(e,t,n){let s;return 58==t&&(s=/^[a-zA-Z_0-9]+:/.exec(e.slice(n+1,e.end)))?e.addElement(e.elt("Emoji",n,n+1+s[0].length)):-1}}]};export{Autolink,BlockContext,Element,Emoji,GFM,InlineContext,LeafBlock,Line,MarkdownParser,Strikethrough,Subscript,Superscript,Table,TaskList,parseCode,parser};